/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFinalStatesIterator;
import morfologik.fsa.FSATraversal;
import morfologik.fsa.MatchResult;
import morfologik.stemming.ArrayViewList;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryIterator;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import morfologik.util.BufferUtils;

public final class DictionaryLookup
implements IStemmer,
Iterable<WordData> {
    private final FSATraversal matcher;
    private final FSAFinalStatesIterator finalStatesIterator;
    private final int rootNode;
    private static final int EXPAND_SIZE = 10;
    private WordData[] forms = new WordData[0];
    private ArrayViewList<WordData> formsList = new ArrayViewList<WordData>(this.forms, 0, this.forms.length);
    private final DictionaryMetadata dictionaryMetadata;
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;
    private final FSA fsa;
    private final char separatorChar;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private CharBuffer charBuffer = CharBuffer.allocate(0);
    private final MatchResult matchResult = new MatchResult();
    private final Dictionary dictionary;

    public DictionaryLookup(Dictionary dictionary) throws IllegalArgumentException {
        this.dictionary = dictionary;
        this.dictionaryMetadata = dictionary.metadata;
        this.rootNode = dictionary.fsa.getRootNode();
        this.fsa = dictionary.fsa;
        this.matcher = new FSATraversal(this.fsa);
        this.finalStatesIterator = new FSAFinalStatesIterator(this.fsa, this.fsa.getRootNode());
        if (this.rootNode == 0) {
            throw new IllegalArgumentException("Dictionary must have at least the root node.");
        }
        if (this.dictionaryMetadata == null) {
            throw new IllegalArgumentException("Dictionary metadata must not be null.");
        }
        this.decoder = dictionary.metadata.getDecoder();
        this.encoder = dictionary.metadata.getEncoder();
        this.separatorChar = dictionary.metadata.getSeparatorAsChar();
    }

    @Override
    public List<WordData> lookup(CharSequence word) {
        int arc;
        byte separator = this.dictionaryMetadata.getSeparator();
        this.formsList.wrap((WordData[])this.forms, 0, 0);
        this.charBuffer.clear();
        this.charBuffer = BufferUtils.ensureCapacity((CharBuffer)this.charBuffer, (int)word.length());
        for (int i = 0; i < word.length(); ++i) {
            char chr = word.charAt(i);
            if (chr == this.separatorChar) {
                return this.formsList;
            }
            this.charBuffer.put(chr);
        }
        this.charBuffer.flip();
        this.byteBuffer = this.charsToBytes(this.charBuffer, this.byteBuffer);
        MatchResult match = this.matcher.match(this.matchResult, this.byteBuffer.array(), 0, this.byteBuffer.remaining(), this.rootNode);
        if (match.kind == -4 && (arc = this.fsa.getArc(match.node, separator)) != 0 && !this.fsa.isArcFinal(arc)) {
            int formsCount = 0;
            this.finalStatesIterator.restartFrom(this.fsa.getEndNode(arc));
            while (this.finalStatesIterator.hasNext()) {
                int tagSize;
                int sepPos;
                ByteBuffer bb = this.finalStatesIterator.next();
                byte[] ba = bb.array();
                int bbSize = bb.remaining();
                if (formsCount >= this.forms.length) {
                    this.forms = Arrays.copyOf(this.forms, this.forms.length + 10);
                    for (int k = 0; k < this.forms.length; ++k) {
                        if (this.forms[k] != null) continue;
                        this.forms[k] = new WordData(this.decoder);
                    }
                }
                WordData wordData = this.forms[formsCount++];
                wordData.reset();
                wordData.wordBuffer = this.byteBuffer;
                wordData.wordCharSequence = word;
                for (sepPos = 0; sepPos < bbSize && ba[sepPos] != separator; ++sepPos) {
                }
                wordData.stemBuffer.clear();
                wordData.stemBuffer = DictionaryLookup.decodeStem(wordData.stemBuffer, ba, sepPos, this.byteBuffer, this.dictionaryMetadata);
                wordData.stemBuffer.flip();
                if ((tagSize = bbSize - ++sepPos) <= 0) continue;
                wordData.tagBuffer = BufferUtils.ensureCapacity((ByteBuffer)wordData.tagBuffer, (int)tagSize);
                wordData.tagBuffer.clear();
                wordData.tagBuffer.put(ba, sepPos, tagSize);
                wordData.tagBuffer.flip();
            }
            this.formsList.wrap((WordData[])this.forms, 0, formsCount);
        }
        return this.formsList;
    }

    public static ByteBuffer decodeStem(ByteBuffer bb, byte[] bytes, int len, ByteBuffer inflectedBuffer, DictionaryMetadata metadata) {
        bb.clear();
        if (len == 0) {
            return bb;
        }
        byte[] infBytes = inflectedBuffer.array();
        int infLen = inflectedBuffer.remaining();
        int code0 = bytes[0] - 65;
        boolean fsaPrefixes = metadata.isUsingPrefixes();
        boolean fsaInfixes = metadata.isUsingInfixes();
        if (bb.capacity() < infLen + len) {
            bb = ByteBuffer.allocate(infLen + len);
        }
        if (code0 >= 0) {
            int stripAtBeginning;
            int stripAtEnd;
            if (!fsaPrefixes && !fsaInfixes) {
                if (code0 <= infLen) {
                    bb.put(infBytes, 0, infLen - code0);
                    bb.put(bytes, 1, len - 1);
                    return bb;
                }
            } else if (fsaPrefixes && !fsaInfixes) {
                int stripAtEnd2;
                if (len > 1 && (stripAtEnd2 = bytes[1] - 65 + code0) <= infLen) {
                    bb.put(infBytes, code0, infLen - stripAtEnd2);
                    bb.put(bytes, 2, len - 2);
                    return bb;
                }
            } else if (fsaInfixes && len > 2 && (stripAtEnd = bytes[2] - 65 + (stripAtBeginning = bytes[1] - 65 + code0)) <= infLen) {
                bb.put(infBytes, 0, code0);
                bb.put(infBytes, stripAtBeginning, infLen - stripAtEnd);
                bb.put(bytes, 3, len - 3);
                return bb;
            }
        }
        bb.clear();
        bb.put(bytes, 0, len);
        return bb;
    }

    private ByteBuffer charsToBytes(CharBuffer chars, ByteBuffer bytes) {
        bytes.clear();
        int maxCapacity = (int)((float)chars.remaining() * this.encoder.maxBytesPerChar());
        if (bytes.capacity() <= maxCapacity) {
            bytes = ByteBuffer.allocate(maxCapacity);
        }
        chars.mark();
        this.encoder.reset();
        if (this.encoder.encode(chars, bytes, true).isError()) {
            bytes.clear();
        }
        bytes.flip();
        chars.reset();
        return bytes;
    }

    @Override
    public Iterator<WordData> iterator() {
        return new DictionaryIterator(this.dictionary, this.decoder, true);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }
}

