/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.value.UntypedAtomicValue;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.saxon.SaxonCommand;

public final class XQueryBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("xquery");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new XQuery(this, config, parent, child, context);
        }
        catch (SaxonApiException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
        catch (IOException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
    }

    private static final class XQuery
    extends SaxonCommand {
        private final List<Fragment> fragments = new ArrayList<Fragment>();

        public XQuery(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) throws SaxonApiException, IOException, XMLStreamException {
            super(builder, config, parent, child, context);
            List fragmentConfigs = this.getConfigs().getConfigList(config, "fragments");
            if (fragmentConfigs.size() == 0) {
                throw new MorphlineCompilationException("At least one fragment must be defined", config);
            }
            if (fragmentConfigs.size() > 1) {
                throw new MorphlineCompilationException("More than one fragment is not yet supported", config);
            }
            for (Config fragment : fragmentConfigs) {
                String queryFile;
                String fragmentPath = this.getConfigs().getString(fragment, "fragmentPath");
                if (!fragmentPath.equals("/")) {
                    throw new MorphlineCompilationException("Non-root fragment paths are not yet supported", config);
                }
                XQueryCompiler compiler = this.processor.newXQueryCompiler();
                compiler.setErrorListener((ErrorListener)new SaxonCommand.DefaultErrorListener());
                compiler.setCompileWithTracing(this.isTracing);
                compiler.setLanguageVersion(this.getConfigs().getString(config, "languageVersion", "1.0"));
                XQueryExecutable executable = null;
                String query = this.getConfigs().getString(fragment, "queryString", null);
                if (query != null) {
                    executable = compiler.compile(query);
                }
                if ((queryFile = this.getConfigs().getString(fragment, "queryFile", null)) != null) {
                    executable = compiler.compile(new File(queryFile));
                }
                if (query == null && queryFile == null) {
                    throw new MorphlineCompilationException("Either query or queryFile must be defined", config);
                }
                if (query != null && queryFile != null) {
                    throw new MorphlineCompilationException("Must not define both query and queryFile at the same time", config);
                }
                XQueryEvaluator evaluator = executable.load();
                Config variables = this.getConfigs().getConfig(fragment, "externalVariables", ConfigFactory.empty());
                for (Map.Entry entry : new Configs().getEntrySet(variables)) {
                    XdmValue xdmValue = XdmNode.wrap((Sequence)new UntypedAtomicValue((CharSequence)entry.getValue().toString()));
                    evaluator.setExternalVariable(new QName((String)entry.getKey()), xdmValue);
                }
                Config fileVariables = this.getConfigs().getConfig(fragment, "externalFileVariables", ConfigFactory.empty());
                for (Map.Entry entry : new Configs().getEntrySet(fileVariables)) {
                    File file = new File(entry.getValue().toString());
                    XdmNode doc = this.parseXmlDocument(file);
                    evaluator.setExternalVariable(new QName((String)entry.getKey()), (XdmValue)doc);
                }
                if (this.isTracing) {
                    evaluator.setTraceListener((TraceListener)new XQueryTraceListener());
                }
                this.fragments.add(new Fragment(fragmentPath, evaluator));
            }
            this.validateArguments();
        }

        @Override
        protected boolean doProcess2(Record inputRecord, InputStream stream) throws SaxonApiException, XMLStreamException {
            this.incrementNumRecords();
            for (Fragment fragment : this.fragments) {
                Record template = inputRecord.copy();
                XQuery.removeAttachments((Record)template);
                XdmNode document = this.parseXmlDocument(stream);
                this.LOG.trace("XQuery input document: {}", (Object)document);
                XQueryEvaluator evaluator = fragment.xQueryEvaluator;
                evaluator.setContextItem((XdmItem)document);
                int i = 0;
                for (XdmItem item : evaluator) {
                    ++i;
                    if (this.LOG.isTraceEnabled()) {
                        this.LOG.trace("XQuery result sequence item #{} is of class: {} with value: {}", new Object[]{i, item.getUnderlyingValue().getClass().getName(), item});
                    }
                    if (item.isAtomicValue()) {
                        this.LOG.debug("Ignoring atomic value in result sequence: {}", (Object)item);
                        continue;
                    }
                    XdmNode node = (XdmNode)item;
                    Record outputRecord = template.copy();
                    boolean isNonEmpty = this.addRecordValues(node, Axis.SELF, XdmNodeKind.ATTRIBUTE, outputRecord);
                    isNonEmpty = this.addRecordValues(node, Axis.ATTRIBUTE, XdmNodeKind.ATTRIBUTE, outputRecord) || isNonEmpty;
                    isNonEmpty = this.addRecordValues(node, Axis.CHILD, XdmNodeKind.ELEMENT, outputRecord) || isNonEmpty;
                    if (!isNonEmpty || this.getChild().process(outputRecord)) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean addRecordValues(XdmNode node, Axis axis, XdmNodeKind nodeTest, Record record) {
            boolean isEmpty = true;
            XdmSequenceIterator iter = node.axisIterator(axis);
            while (iter.hasNext()) {
                String strValue;
                XdmNode child = (XdmNode)iter.next();
                if (child.getNodeKind() != nodeTest || (strValue = child.getStringValue()).length() <= 0) continue;
                record.put(child.getNodeName().getLocalName(), (Object)strValue);
                isEmpty = false;
            }
            return !isEmpty;
        }

        private static final class Fragment {
            private final String fragmentPath;
            private final XQueryEvaluator xQueryEvaluator;

            public Fragment(String fragmentPath, XQueryEvaluator xQueryEvaluator) {
                this.fragmentPath = fragmentPath;
                this.xQueryEvaluator = xQueryEvaluator;
            }
        }
    }
}

